/***************************************************************************
 *   Copyright (C) 2008 by Manuel Schrape                                  *
 *   manuel.schrape@gmx.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PARAMETER_POSITIONS_H
#define PARAMETER_POSITIONS_H

// Positionen der Navidaten im OSD-Datensatz
////////////////////////////////////////////

static const int N_VERSION          = 0;
static const int N_CUR_LONGITUDE    = 1;
static const int N_CUR_LATITUDE     = 5;
static const int N_CUR_ALTITUDE     = 9;
static const int N_CUR_STATUS       = 13;

static const int N_TAR_LONGITUDE    = 14; //16
static const int N_TAR_LATITUDE     = 18; //20
static const int N_TAR_ALTITUDE     = 22; //24
static const int N_TAR_STATUS       = 26; //28
static const int N_TAR_DISTANCE     = 27; //32
static const int N_TAR_ANGLE        = 29; //34

static const int N_HOME_LONGITUDE   = 31; //36
static const int N_HOME_LATITUDE    = 35; //40
static const int N_HOME_ALTITUDE    = 39; //44
static const int N_HOME_STATUS      = 43; //48
static const int N_HOME_DISTANCE    = 44; //52
static const int N_HOME_ANGLE       = 46; //54

static const int N_WP_INDEX         = 48; //56
static const int N_WP_NUMBER        = 49; //57

static const int N_SATS_IN_USER     = 50; //58
static const int N_ALTIMETER        = 51; //59
static const int N_VARIOMETER       = 53; //61
static const int N_FLYING_TIME      = 55; //63
static const int N_UBAT             = 57; //65
static const int N_GROUND_SPEED     = 58; //66
static const int N_HEADING          = 60; //68
static const int N_COMAPSS_HEADING  = 62; //70
static const int N_ANGLE_NICK       = 64; //72
static const int N_ANGLE_ROLL       = 65; //73
static const int N_RC_QUALITY       = 66; //74
static const int N_MK_FLAGS         = 67; //75
static const int N_NC_FLAGS         = 68; //76
static const int N_ERRORCODE        = 69; //77
static const int N_OP_RADIUS        = 70; //77
static const int N_TOP_SPEED        = 71; //77
static const int N_HOLD_TIME        = 73; //77

// Positionen der Setting-Parameter
///////////////////////////////////

#ifdef _BETA_
static const int VERSION_SETTINGS = 76;
static const int VERSION_OSD      = 1;
static const int VERSION_MIXER    = 1;
#else
static const int VERSION_SETTINGS = 76;
static const int VERSION_OSD      = 1;
static const int VERSION_MIXER    = 1;
#endif

static const int MAXMOTOR = 12;

static const int MaxParameter = 98;

static const int P_KANAL_GAS   = 0;
static const int P_KANAL_GIER  = 1;
static const int P_KANAL_NICK  = 2;
static const int P_KANAL_ROLL  = 3;
static const int P_KANAL_POTI1 = 4;
static const int P_KANAL_POTI2 = 5;
static const int P_KANAL_POTI3 = 6;
static const int P_KANAL_POTI4 = 7;
static const int P_GLOBAL_CONF = 8;
static const int P_MIN_GAS     = 9;

static const int P_DRUCK_D       = 10;
static const int P_MAXHOEHE      = 11;
static const int P_HOEHE_P       = 12;
static const int P_HOEHE_GAIN    = 13;
static const int P_HOEHE_ACC     = 14;
static const int P_STICK_P       = 15;
static const int P_STICK_D       = 16;
static const int P_GIER_P        = 17;
static const int P_GAS_MIN       = 18;
static const int P_GAS_MAX       = 19;

static const int P_GYRO_ACC_FAKTOR = 20;
static const int P_KOMPASS_WIRKUNG = 21;
static const int P_GYRO_P          = 22;
static const int P_GYRO_I          = 23;
static const int P_GYRO_D          = 24;
static const int P_UNTERSPANNUNG   = 25;
static const int P_NOTGAS          = 26;
static const int P_NOTGASZEIT      = 27;
static const int P_AUSRICHTUNG     = 28;
static const int P_FAKTOR_I        = 29;

static const int P_USER_1          = 30;
static const int P_USER_2          = 31;
static const int P_USER_3          = 32;
static const int P_USER_4          = 33;
static const int P_SERVO_NICK_CONT = 34;
static const int P_SERVO_NICK_COMP = 35;
static const int P_SERVO_NICK_MIN  = 36;
static const int P_SERVO_NICK_MAX  = 37;
static const int P_SERVO_ROLL_CONT = 38;
static const int P_SERVO_ROLL_COMP = 39;

static const int P_SERVO_ROLL_MIN  = 40;
static const int P_SERVO_ROLL_MAX  = 41;
static const int P_SERVO_REFR      = 42;
static const int P_LOOP_GAS_LIMIT  = 43;
static const int P_LOOP_THRESHOLD  = 44;
static const int P_LOOP_HYSTERESE  = 45;
static const int P_ACHS_KOPPLUNG1  = 46;
static const int P_ACHS_KOPPLUNG2  = 47;
static const int P_ACHS_GKOPPLUNG  = 48;
static const int P_WINKEL_NICK     = 49;

static const int P_WINKEL_ROLL     = 50;
static const int P_GYRO_ACC_ABGL   = 51;
static const int P_DRIFT_KOMP      = 52;
static const int P_DYNAMIC_STAB    = 53;
static const int P_USER_5          = 54;
static const int P_USER_6          = 55;
static const int P_USER_7          = 56;
static const int P_USER_8          = 57;
static const int P_J16_BITMASK     = 58;
static const int P_J16_TIMING      = 59;

static const int P_J17_BITMASK      = 60;
static const int P_J17_TIMING       = 61;
static const int P_NAV_GPS_MODE     = 62;
static const int P_NAV_GPS_GAIN     = 63;
static const int P_NAV_GPS_P        = 64;
static const int P_NAV_GPS_I        = 65;
static const int P_NAV_GPS_D        = 66;
static const int P_NAV_GPS_P_LIMIT  = 67;
static const int P_NAV_GPS_I_LIMIT  = 68;
static const int P_NAV_GPS_D_LIMIT  = 69;

static const int P_NAV_GPS_ACC      = 70;
static const int P_NAV_GPS_MIN      = 71;
static const int P_NAV_STICK_THRE   = 72;
static const int P_NAV_WIND_CORR    = 73;
static const int P_NAV_SPEED_COMP   = 74;
static const int P_NAV_RADIUS       = 75;
static const int P_NAV_ANGLE_LIMIT  = 76;
static const int P_NAV_PH_LOGINTIME = 77;
static const int P_EXTERNAL         = 78;
static const int P_LOOP_CONFIG      = 79;

static const int P_SERVO_COMPI      = 80;
static const int P_RESERVED         = 81;
static const int P_NAME             = 85;

#endif
